/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public abstract class AbstractBufferMemoryIO
extends AbstractMemoryIO {
    protected final ByteBuffer buffer;

    public AbstractBufferMemoryIO(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    public long address() {
        throw new UnsupportedOperationException("Not a direct memory object.");
    }

    public final ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public byte getByte(long l) {
        return this.buffer.get((int)l);
    }

    public short getShort(long l) {
        return this.buffer.getShort((int)l);
    }

    public int getInt(long l) {
        return this.buffer.getInt((int)l);
    }

    public long getLong(long l) {
        return this.buffer.getLong((int)l);
    }

    public float getFloat(long l) {
        return this.buffer.getFloat((int)l);
    }

    public double getDouble(long l) {
        return this.buffer.getDouble((int)l);
    }

    public void putByte(long l, byte by) {
        this.buffer.put((int)l, by);
    }

    public void putShort(long l, short s) {
        this.buffer.putShort((int)l, s);
    }

    public void putInt(long l, int n) {
        this.buffer.putInt((int)l, n);
    }

    public void putLong(long l, long l2) {
        this.buffer.putLong((int)l, l2);
    }

    public void putFloat(long l, float f) {
        this.buffer.putFloat((int)l, f);
    }

    public void putDouble(long l, double d) {
        this.buffer.putDouble((int)l, d);
    }

    public String getString(long l, int n) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)l), Charset.defaultCharset());
    }

    public void putString(long l, String string) {
        BufferUtil.putString(BufferUtil.slice(this.buffer, (int)l), Charset.defaultCharset(), string);
    }

    public void get(long l, byte[] byArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2).get(byArray, n, n2);
    }

    public void get(long l, short[] sArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 16 / 8).asShortBuffer().get(sArray, n, n2);
    }

    public void get(long l, int[] nArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 32 / 8).asIntBuffer().get(nArray, n, n2);
    }

    public void get(long l, long[] lArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 64 / 8).asLongBuffer().get(lArray, n, n2);
    }

    public void get(long l, float[] fArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 32 / 8).asFloatBuffer().get(fArray, n, n2);
    }

    public void get(long l, double[] dArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 64 / 8).asDoubleBuffer().get(dArray, n, n2);
    }

    public void put(long l, byte[] byArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2).put(byArray, n, n2);
    }

    public void put(long l, short[] sArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 16 / 8).asShortBuffer().put(sArray, n, n2);
    }

    public void put(long l, int[] nArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 32 / 8).asIntBuffer().put(nArray, n, n2);
    }

    public void put(long l, long[] lArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 64 / 8).asLongBuffer().put(lArray, n, n2);
    }

    public void put(long l, float[] fArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 32 / 8).asFloatBuffer().put(fArray, n, n2);
    }

    public void put(long l, double[] dArray, int n, int n2) {
        BufferUtil.slice(this.buffer, (int)l, n2 * 64 / 8).asDoubleBuffer().put(dArray, n, n2);
    }

    public String getString(long l) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)l), Charset.defaultCharset());
    }

    public String getString(long l, int n, Charset charset) {
        return BufferUtil.getString(BufferUtil.slice(this.buffer, (int)l, n), charset);
    }

    public void putString(long l, String string, int n, Charset charset) {
        BufferUtil.putString(BufferUtil.slice(this.buffer, (int)l, n), charset, string);
    }

    public int indexOf(long l, byte by, int n) {
        while (l > -1L) {
            if (this.buffer.get((int)l) == by) {
                return (int)l;
            }
            ++l;
        }
        return -1;
    }

    public void setMemory(long l, long l2, byte by) {
        int n = 0;
        while ((long)n < l2) {
            this.buffer.put((int)l + n, by);
            ++n;
        }
    }
}

